setwd("<your directory or folder path>")
df1 <- read.csv("20180701 Example 11.2 BMA v.2.csv")
#
#
#  need to execute library(randomForest) once during R session
#
# VARIABLES:
# X.01
# X.02
# X.03
# X.04
# X.05
# X.06
# X.07
# X.08
# X.09
# X.10
# Response
#
library(rpart) #package for CART
library(randomForest) #package for the randomForest() function
nbin <- nrow(df1)
set.seed(13) #fixes random seed for repeatability
testind <- rbinom(n=nbin,size=1,prob=0.1) #randomly selected 10%

df2 <- cbind(df1,testind)
#detach(df1)
attach(df2)
dftest <- subset(df2,testind==1)
dftrain <- subset(df2,testind==0)

detach(df2)
attach(dftrain)
linreg <- lm(Response ~ X.01 + X.02 + X.03 + X.04 + X.05 + X.06 + X.07 + X.08 + X.09 + X.10,data=dftrain)
step.model <- step(linreg)
# Make some plots:
#
# dev.new() allows more plots to be made without overwriting previous plots
#

forest.model <- randomForest(Response ~ X.01 + X.02 + X.03 + X.04 + X.05 + X.06 + X.07 + X.08 + X.09 + X.10,importance=TRUE,data=dftrain)
forest.pred <- predict(forest.model,newdata=dftest,type="response")

# Make some plots:

summary(linreg)
summary(step.model)
#
#
#
cart.model <- rpart(Response ~ X.01 + X.02 + X.03 + X.04 + X.05 + X.06 + X.07 + X.08 + X.09 + X.10,data=dftrain)

#plot(cart.model,xlim=c(0.75,5.33),ylim=c(-0.01,1.10))
plot(cart.model,ylim=c(0.1,1.10),main="Classification and Regression Tree")

text(cart.model,use.n=TRUE)
dev.new()
rsq.rpart(cart.model)
dev.new()
pred.lin <- predict(linreg,newdata=dftest)
pred.step <- predict(step.model,newdata=dftest)
predcart <- predict(cart.model,dftest)
plot(dftest$Response,predcart,pch=1,xlab=c("Actual Response"),ylab=c("Predicted Response"),main="Random Forest and Other Predictions for Test Data")
points(x=dftest$Response,forest.pred,pch=2)
points(x=dftest$Response,y=pred.lin,pch=3)
points(x=dftest$Response,y=pred.step,pch=4)
legend(x=0,y=100,legend=c("CART","Random Forest","Linear Model","Stepwise"),pch=c(1,2,3,4))
forest.model$importance
